
<?php $__env->startSection('title', 'Laporan'); ?>


<?php $__env->startPush('addon-style'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="header bg-primary pb-6">
        <div class="container-fluid">
          <div class="header-body">
            <div class="row align-items-center py-4">
              <div class="col-lg-6 col-7">
                <h6 class="h2 text-white d-inline-block mb-0">Laporan</h6>
                <nav aria-label="breadcrumb" class="d-none d-md-inline-block ml-md-4">
                  <ol class="breadcrumb breadcrumb-links breadcrumb-dark">
                    <li class="breadcrumb-item"><a href="#"><i class="fas fa-home"></i></a></li>
                    <li class="breadcrumb-item active" aria-current="page">Lihat</li>
                    <li class="breadcrumb-item"><a href="#">Laporan</a></li>
                  </ol>
                </nav>
              </div>
            </div>
          </div>
        </div>
      </div>
    <!-- Page content -->
    <div class="container-fluid mt--6">
        <div class="row">
          <div class="col-xl-4 order-xl-1">
            <div class="card">
              <div class="card-header border-0 pt-8 pt-md-4 pb-0 pb-md-4">
                <h3>Filter Laporan</h3>
              </div>
              <div class="card-body">
               <form action="<?php echo e(route('laporan.get')); ?>" method="POST">
                   <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <input type="text" name="date_from" class="form-control" placeholder="Tanggal Awal"
                            onfocusin="(this.type='date')" onfocusout="(this.type='text')" value="<?php echo e($from ?? ''); ?>">
                    </div>
                    <div class="form-group">
                        <input type="text" name="date_to" class="form-control" placeholder="Tanggal Akhir"
                            onfocusin="(this.type='date')" onfocusout="(this.type='text')" value="<?php echo e($to ?? ''); ?>">
                    </div>
                    <button type="submit" class="btn btn-primary mt-3" style="width: 100%">Cari Laporan</button>
               </form>
              </div>
            </div>
          </div>
          <div class="col-xl-12 order-xl-2">
            <div class="card">
              <div class="card-header">
                <div class="row align-items-center">
                  <div class="col-8">
                    <h3 class="mb-0">Data Pengaduan</h3>
                  </div>
                  <div class="col text-right">
                    <?php if($pengaduan ?? ''): ?>
                      <form action="<?php echo e(route('laporan.export')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="date_from" value="<?php echo e($from); ?>">
                        <input type="hidden" name="date_to" value="<?php echo e($to); ?>">
                        <button type="submit" class="btn btn-info">Export PDF</button>
                      </form>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
              <div class="card-body">
                <?php if($pengaduan ?? ''): ?>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Tgl Pengaduan</th>
                                <th>Nama</th>
                                <th>Judul Laporan</th>
                                <th>Isi Laporan</th>
                                <th>Tgl Kejadian</th>
                                <th>Lokasi Kejadian</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $pengaduan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($k += 1); ?>.</td>
                                <td><?php echo e(Carbon\Carbon::parse($i->tgl_pengaduan)->format('d-m-Y')); ?></td>
                                <td><?php echo e($i->user->name); ?></td>
                                <td><?php echo e($i->judul_laporan); ?></td>
                                <td><?php echo e($i->isi_laporan); ?></td>
                                <td><?php echo e(Carbon\Carbon::parse($i->tgl_kejadian)->format('d-m-Y')); ?></td>
                                <td><?php echo e($i->lokasi_kejadian); ?></td>
                                <td><?php echo e($i->status); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('addon-script'); ?>
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function() {
        $('#pengaduanTable').DataTable();
    } );
</script>
<?php if(session()->has('status')): ?>
<script>
    Swal.fire({
        title: 'Pemberitahuan!',
        text: "<?php echo e(Session::get('status')); ?>",
        icon: 'success',
        confirmButtonColor: '#28B7B5',
        confirmButtonText: 'OK',
    });
    </script>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\app-pengaduan-masyarakat\resources\views/pages/admin/laporan/index.blade.php ENDPATH**/ ?>