
<?php $__env->startSection('title', 'Pengaduan'); ?>


<?php $__env->startPush('addon-style'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="header bg-primary pb-6">
        <div class="container-fluid">
          <div class="header-body">
            <div class="row align-items-center py-4">
              <div class="col-lg-6 col-7">
                <h6 class="h2 text-white d-inline-block mb-0">Tanggapan</h6>
                <nav aria-label="breadcrumb" class="d-none d-md-inline-block ml-md-4">
                  
                </nav>
              </div>
            </div>
          </div>
        </div>
      </div>
    <!-- Page content -->
    <div class="container-fluid mt--6">
        <div class="row">
          <div class="col-xl-12 order-xl-1">
            <div class="card">
              <div class="card-header text-center border-0 pt-8 pt-md-4 pb-0 pb-md-4">
                <h3>Data Pengaduan</h3>
              </div>
              <div class="card-body">
                <table class="table">
                    <tbody>
                        <tr>
                            <th>NIK</th>
                            <td>:</td>
                            <td><?php echo e($pengaduan->nik); ?></td>
                        </tr>
                        <tr>
                            <th>Nama</th>
                            <td>:</td>
                            <td><?php echo e($pengaduan->user->name); ?></td>
                        </tr>
                        <tr>
                            <th>Tanggal Pengaduan</th>
                            <td>:</td>
                            <td><?php echo e(\Carbon\Carbon::parse($pengaduan->tgl_pengaduan)->format('d-m-Y')); ?></td>
                        </tr>
                        <tr>
                            <th>Judul Laporan</th>
                            <td>:</td>
                            <td><?php echo e($pengaduan->judul_laporan); ?></td>
                        </tr>
                        <tr>
                            <th>Isi Laporan</th>
                            <td>:</td>
                            <td><?php echo e($pengaduan->isi_laporan); ?></td>
                        </tr>
                        <tr>
                            <th>Tanggal Kejadian</th>
                            <td>:</td>
                            <td><?php echo e(\Carbon\Carbon::parse($pengaduan->tgl_kejadian)->format('d-m-Y')); ?></td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>:</td>
                            <td>
                                <?php if($pengaduan->status == '0'): ?>
                                    <span class="text-sm badge badge-danger">Pending</span>
                                <?php elseif($pengaduan->status == 'proses'): ?>
                                    <span class="text-sm badge badge-warning">Proses</span>
                                <?php else: ?>
                                    <span class="text-sm badge badge-success">Selesai</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Lokasi Kejadian</th>
                            <td>:</td>
                            <td><?php echo e($pengaduan->lokasi_kejadian); ?></td>
                        </tr>
                        <tr>
                          <th>Foto Kejadian</th>
                          <td>:</td>
                          <td><img src="<?php echo e(Storage::url($pengaduan->foto)); ?> " class="card-img"></td>
                        </tr>
                        
                    </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="col-xl-6 order-xl-2">
            <div class="card">
              <div class="card-header">
                <div class="row align-items-center">
                  <div class="col-8">
                    <h3 class="mb-0">Tanggapan</h3>
                  </div>
                </div>
              </div>
              <div class="card-body">
                <form action="<?php echo e(route('tanggapan')); ?> " method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id_pengaduan" value="<?php echo e($pengaduan->id_pengaduan); ?>">
                  <!-- Tanggapan -->
                  <div class="">
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select name="status" class="form-control" id="status">
                            <?php if($pengaduan->status == '0'): ?>
                                <option selected value="0">Pending</option>
                                <option value="proses">Proses</option>
                                <option value="selesai">Selesai</option>
                            <?php elseif($pengaduan->status == 'proses'): ?>
                                <option value="0">Pending</option>
                                <option selected value="proses">Proses</option>
                                <option value="selesai">Selesai</option>
                            <?php else: ?>
                                <option value="0">Pending</option>
                                <option value="proses">Proses</option>
                                <option selected value="selesai">Selesai</option>
                            <?php endif; ?>
                        </select>
                      </div>
                    <div class="form-group">
                      <label class="form-control-label">Tanggapan</label>
                      <textarea rows="4" class="form-control" name="tanggapan" id="tanggapan" placeholder="Ketik tanggapan"><?php echo e($tanggapan->tanggapan ?? ''); ?></textarea>
                    </div>
                  </div>

                  <button type="submit" class="btn btn-primary">Kirim</button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('addon-script'); ?>
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function() {
        $('#pengaduanTable').DataTable();
    } );
</script>
<?php if(session()->has('status')): ?>
<script>
    Swal.fire({
        title: 'Pemberitahuan!',
        text: "<?php echo e(Session::get('status')); ?>",
        icon: 'success',
        confirmButtonColor: '#28B7B5',
        confirmButtonText: 'OK',
    });
    </script>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\app-pengaduan-masyarakat\resources\views/pages/admin/pengaduan/show.blade.php ENDPATH**/ ?>